create or replace package body tbicds.PCK_REPORTS_PAT is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
/*Get previous intake score*/
function GetPrevIntakeScore(pi_nMID in number,
                            pi_vPatientID in varchar2,
                            pi_nIntakeID in number)
  
 return number
 
 is
 
   v_nScore number := 0;
   
 begin
   
   select score into v_nScore 
   from 
      (select s1.score   
         from data_intake_score s1,
              data_intake s2
        where s2.patient_id = s1.patient_id
          and s2.intake_id = s1.intake_id
          and s2.mid = s2.mid
            
          and s1.mid = pi_nMID
          and s1.patient_id = pi_vPatientID 
          and s1.series = 0 
          
          and s2.intake_id in (select intake_id 
                               from pat_pw_event_module aa,
                               pat_pw_event aaa
                               where aa.pat_pw_event_id = aaa.pat_pw_event_id
                               and aaa.status = 2
                               and ((select count(*)  
                                      from data_intake_responses
                                     where intake_id = aa.intake_id
                                       and mid = 4042 
                                       and tid=1
                                       and qid=1
                                       and rid=21) = 0) 
                               ) 
     
            
          and s2.complete_date < 
                     
          (select complete_date   
            from data_intake
           where patient_id = pi_vPatientID
             and intake_id = pi_nIntakeID
             and mid = pi_nMID 
             and rownum = 1 ) 
      order by s2.complete_date desc
      )where rownum = 1; 

    
    return v_nScore;

exception
    when others then
    return null;  
end;

/*Get current intake score*/
function GetCurrentIntakeScore(pi_vPatientID in varchar2,
                               pi_nMID in number)
  
 return number
 
 is
 
   v_nScore number := 0;
   
 begin
   
   select score into v_nScore 
   from 
       ( select score from (
        select tds.mid, di.complete_date, tds.score   
         from data_intake_score tds,
              data_intake di
        where tds.patient_id = pi_vPatientID
          and tds.mid = pi_nMID
          and tds.intake_id = di.intake_id
          and tds.series = 0 
          and di.intake_id in (select intake_id 
                               from pat_pw_event_module aa,
                               pat_pw_event aaa
                               where aa.pat_pw_event_id = aaa.pat_pw_event_id
                               and aaa.status = 2
                               
                               and ((select count(*)  
                                      from data_intake_responses
                                     where intake_id = aa.intake_id
                                       and mid = 4042 
                                       and tid=1
                                       and qid=1
                                       and rid=21) = 0) 
                               ) 
                               
        order by di.complete_date desc ))
        where rownum = 1;

    
    return v_nScore;

exception
    when others then
    return null;  
end;

/*Get note dates RS*/
procedure GetNoteDatesRS( pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_vPatientID       in varchar2,
                          pi_dtFrom           in date,
                          pi_dtTo             in date,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2,
                          rs                  out RetRefCursor) 
is

strSQL       varchar2(4000) := '';

begin  
  

strSQL := 'select t.patient_id, 
                  t.pat_pw_event_id, 
                  t.tiu_date_submitted 
             from pat_pw_event t 
            where t.patient_id = :PATIENT_ID
              and t.status = 2 
              and (trunc(t.tiu_date_submitted) >= :FROM_DATE 
                   AND trunc(t.tiu_date_submitted) <= :TO_DATE)
         order by t.tiu_date_submitted desc';
  
    open rs 
    for strSQL
    using pi_vPatientID,
          pi_dtFrom,
          pi_dtTo;
    
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'Error retrieving notes';
  end;

/*Get note teext RS*/
procedure GetNoteTextRS( pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_vPatientID       in varchar2,
                          pi_nPatPWEventID    in number,
                          pi_dtFrom           in date,
                          pi_dtTo             in date,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2,
                          rs                  out RetRefCursor) 
is

strSQL       varchar2(4000) := '';

begin  
  

strSQL := 'select t.note_text 
             from pat_pw_event t
            where t.patient_id = :PATIENT_ID
              and t.pat_pw_event_id = :PAT_PW_EVENT_ID 
              and t.status = 2 
              and (trunc(t.tiu_date_submitted) >= :FROM_DATE 
                   AND trunc(t.tiu_date_submitted) <= :TO_DATE)';
  
    open rs 
    for strSQL
    using pi_vPatientID,
          pi_nPatPWEventID,
          pi_dtFrom,
          pi_dtTo;
    
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'Error retrieving notes';
  end;

/*Get instrument score recordset*/
procedure GetInstrumentScoreRS( pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_vPatientID       in varchar2,
                                pi_nMID             in number,
                                pi_dtFrom           in date,
                                pi_dtTo             in date,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out RetRefCursor) 
is

--strSQL       varchar2(4000) := '';

begin  
  

/*strSQL := 'select t.patient_id, t.complete_date, 
          t.intake_id, t.mid, t3.module, t3.acronym, t2.score, 
          t2.interpretation 
  from data_intake t, data_intake_score t2, intake_module t3 
 where t.intake_id = t2.intake_id
   and t.mid = t3.mid 
   and t2.mid = t3.mid
   and t2.series = 0
   
   and t.intake_id in (select intake_id 
                         from pat_pw_event_module aa,
                              pat_pw_event aaa
                        where aa.pat_pw_event_id = aaa.pat_pw_event_id
                          and aaa.status = 2) 
       
   and t.intake_id in (select intake_id 
                       from data_intake_score 
                       where series=0)
   and t.mid = :MID
   and t.patient_id = :PATIENT_ID
   and (trunc(t.complete_date) >= :FROM_DATE 
              AND trunc(t.complete_date) <= :TO_DATE)
   order by t.complete_date desc';
  
    open rs 
    for strSQL
    using pi_nMID,
          pi_vPatientID,
          pi_dtFrom,
          pi_dtTo;
    */
   
    
 
 if pi_nMID != 4042 then 
   
   open rs for
    
    select t.patient_id, 
           t.intake_id, 
           t.mid, 
           t3.module,
           t3.acronym,
           t2.score, 
           t2.interpretation,
           evm.date_completed as complete_date,
           appu.name,
         
         --if mid = 4042 and rid=21 then this is a goal           
         (select count(*)  
            from data_intake_responses
           where intake_id = t.intake_id
             and mid = 4042 
             and tid=1
             and qid=1
             and rid=21) as is_goal
           
      from data_intake t, 
           data_intake_score t2, 
           intake_module t3,
           pat_pw_event_module evm,
           pat_pw_event ev, 
           fx_user fxu,
           app_user appu
           
     where t.intake_id = t2.intake_id
       and t.mid = t3.mid 
       and t2.mid = t3.mid
       and t2.series = 0 --SCORE
       and t.intake_id = evm.intake_id
       and evm.pat_pw_event_id = ev.pat_pw_event_id
       and ev.status = 2 --EVENT CLOSED
       and fxu.site_id = evm.site_id
       and fxu.fx_user_id = evm.completed_by
       and appu.fx_user_id = fxu.fx_user_id
       and t.mid = pi_nMID
       and t.patient_id = pi_vPatientID
       and (trunc(t.complete_date) >= pi_dtFrom 
                  AND trunc(t.complete_date) <= pi_dtTo)
       order by t.complete_date desc;
  
 else
   
   --EXCLUDE FIM GOAL from MID 4042
   open rs for
    select t.patient_id, 
           t.intake_id, 
           t.mid, 
           t3.module,
           t3.acronym,
           t2.score, 
           t2.interpretation,
           evm.date_completed as complete_date,
           appu.name,
       
       --if mid 4042 and rid=21 then this is a goal             
       (select count(*)  
          from data_intake_responses
         where intake_id = t.intake_id
           and mid = 4042 
           and tid=1
           and qid=1
           and rid=21) as is_goal
           
      from data_intake t, 
           data_intake_score t2, 
           intake_module t3,
           pat_pw_event_module evm,
           pat_pw_event ev, 
           fx_user fxu,
           app_user appu
           
     where t.intake_id = t2.intake_id
       and t.mid = t3.mid 
       and t2.mid = t3.mid
       and t2.series = 0 --SCORE
       and t.intake_id = evm.intake_id
       and evm.pat_pw_event_id = ev.pat_pw_event_id
       and ev.status = 2 --EVENT CLOSED
       and fxu.site_id = evm.site_id
       and fxu.fx_user_id = evm.completed_by
       and appu.fx_user_id = fxu.fx_user_id
       and t.mid = pi_nMID
       and t.patient_id = pi_vPatientID
       and (trunc(t.complete_date) >= pi_dtFrom 
                  AND trunc(t.complete_date) <= pi_dtTo)
       
       --exclude mid 4042 rid 21           
       and ( (select count(*)   
                from data_intake_responses 
               where intake_id = t.intake_id 
                 and mid=4042 
                 and tid=1 
                 and qid=1
                 and rid=21 ) < 1)
               
       order by t.complete_date desc;
  
  end if;
                 
    
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'Error retrieving scored instruments';
  end;
 
 /*Get trend base recordset*/  
 procedure GetTrendBaseRS( pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           pi_vPatientID       in varchar2,
                           po_nStatusCode      out number,
                           po_vStatusComment   out varchar2,
                           rs                  out RetRefCursor) 
is

strSQL       long := '';

begin  

strSQL := ' select t.patient_id, 
       t.pat_pw_id, 
       t.pat_pw_event_id, 
       t.pw_event_module_id, 
       t.mid,
       t.intake_id,
       t.date_completed,
       t2.module,
       
       (select count(*)  
            from data_intake_responses
           where intake_id = t.intake_id
             and mid = 4042 
             and tid=1
             and qid=1
             and rid=21) as is_goal, 
             
       (select es.event_severity_id  
          from pat_pw_event_entry pe,
               stat_event_severity es
          where pe.event_severity_id = es.event_severity_id 
            and pe.patient_id = t.patient_id
            and pe.pw_event_module_id = t.pw_event_module_id
            and pe.event_date = 
             (select max(event_date) 
                from pat_pw_event_entry pe2
               where pe2.pw_event_module_id = t.pw_event_module_id)
            and rownum=1) as current_severity_id,
            
           (select tds.interpretation   
              from data_intake_score tds
              where tds.patient_id = t.patient_id
              and tds.intake_id = t.intake_id
              and tds.patient_id = t.patient_id 
              and tds.mid = t.mid 
              and tds.series = 0
              and rownum=1) as current_interpretation,

           (select es.event_status 
          from pat_pw_event_entry pe,
               stat_event_status es
          where pe.event_status_id = es.event_status_id
            and pe.patient_id = t.patient_id
            and pe.pw_event_module_id = t.pw_event_module_id
            and pe.event_date = 
             (select max(event_date) 
                from pat_pw_event_entry pe2
               where pe2.pw_event_module_id = t.pw_event_module_id)
            and rownum=1) as current_status,              
      
          (select pe.event_status_id  
          from pat_pw_event_entry pe,
               stat_event_status es
          where pe.event_status_id = es.event_status_id
            and pe.patient_id = t.patient_id
            and pe.pw_event_module_id = t.pw_event_module_id
            and pe.event_date = 
             (select max(event_date) 
                from pat_pw_event_entry pe2
               where pe2.pw_event_module_id = t.pw_event_module_id)
            and rownum=1) as current_status_id,
            
         (select es.event_severity  
          from pat_pw_event_entry pe,
               stat_event_severity es
          where pe.event_severity_id = es.event_severity_id 
            and pe.patient_id = t.patient_id
            and pe.pw_event_module_id = t.pw_event_module_id
            and pe.event_date = 
             (select max(event_date) 
                from pat_pw_event_entry pe2
               where pe2.pw_event_module_id = t.pw_event_module_id)
            and rownum=1) as current_severity,
            
        (select nvl(tt.status, 0) 
             from pat_pw_event tt 
           where tt.pat_pw_event_id = t.pat_pw_event_id) 
           as event_status,
                     
       PCK_REPORTS_PAT.GetCurrentIntakeScore(t.patient_id, t.mid) as current_score,
       PCK_REPORTS_PAT.GetPrevIntakeScore(t.mid, t.patient_id, t.intake_id) as prev_score       

 from  PAT_PW_EVENT_MODULE t,
       intake_module t2
       
where  t.patient_id = :PAT_ID
       and t2.mid = t.mid 
       and t.status = 2 
       and nvl(t.intake_id,-1) > 0 
       and t.intake_id in (select intake_id 
                             from data_intake_score 
                            where series=0)
 
       and t.date_completed = (select max(x.date_completed) 
                                 from PAT_PW_EVENT_MODULE x, 
                                      pat_pw_event x2
                                 where x.mid = t2.mid
                                   and x.patient_id = t.patient_id
                                   and x.pat_pw_event_id = x2.pat_pw_event_id 
                                   and x2.status = 2
                                 
                                   and   (select count(*)  
                                          from data_intake_responses
                                         where intake_id = x.intake_id
                                           and mid = 4042 
                                           and tid=1
                                           and qid=1
                                           and rid=21) = 0 
                                 
                                 )
                                 
     order by t.date_completed desc';
  
    open rs 
    for strSQL
    using pi_vPatientID;
    
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'Error retrieving trend data';

  end; 
  
 
/*gets all scorable modules for this patient and date range
with the 10 most recent columns nulled out for fill in later*/
procedure GetInstrumentsBaseRS( pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_vPatientID       in varchar2,
                                pi_dtFrom           in date,
                                pi_dtTo             in date,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out RetRefCursor) 
is

strSQL       varchar2(4000) := '';

begin  

strSQL := 'select distinct(t.mid), 
                 case
                   when t3.acronym is null then 
                     case 
                       when length(t3.module) > 10 then trim(substr(t3.module,0,10)) || ''...''
                       else t3.module
                     end
                   else t3.acronym
                 end as short_name, 
                 t3.module, 
                 null as score_10,
                 null as score_9,
                 null as score_8,
                 null as score_7,
                 null as score_6,
                 null as score_5,
                 null as score_4,
                 null as score_3,
                 null as score_2,
                 null as score_1,
                 null as date_10,
                 null as date_9,
                 null as date_8,
                 null as date_7,
                 null as date_6,
                 null as date_5,
                 null as date_4,
                 null as date_3,
                 null as date_2,
                 null as date_1,
                 null as name_10,
                 null as name_9,
                 null as name_8,
                 null as name_7,
                 null as name_6,
                 null as name_5,
                 null as name_4,
                 null as name_3,
                 null as name_2,
                 null as name_1,
                 null as interpretation_10,
                 null as interpretation_9,
                 null as interpretation_8,
                 null as interpretation_7,
                 null as interpretation_6,
                 null as interpretation_5,
                 null as interpretation_4,
                 null as interpretation_3,
                 null as interpretation_2,
                 null as interpretation_1
            from data_intake t, data_intake_score t2, intake_module t3 
           where t.intake_id = t2.intake_id
             and t.mid = t3.mid 
             
              and t.intake_id in (select intake_id 
                         from pat_pw_event_module aa,
                              pat_pw_event aaa
                        where aa.pat_pw_event_id = aaa.pat_pw_event_id
                          and aaa.status = 2
                          
                          and ((select count(*)  
                                      from data_intake_responses
                                     where intake_id = aa.intake_id
                                       and mid = 4042 
                                       and tid=1
                                       and qid=1
                                       and rid=21) = 0) ) 
 

             and t.patient_id = :PATIENT_ID
              AND (trunc(t.complete_date) >= :FROM_DATE 
              AND trunc(t.complete_date) <= :TO_DATE)
             and t2.mid = t3.mid
             and t2.series = 0
             and t.intake_id in 
             (select intake_id from data_intake_score where series=0)
             order by short_name';
  
    open rs 
    for strSQL
    using pi_vPatientID,
          pi_dtFrom,
          pi_dtTo;
    
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'Error retrieving scored instruments';
  end;
             
  /*get a record set of all patients for the site*/
  procedure GetPatPopulationRS(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               pi_vKey             in varchar2,
                               po_nStatusCode      out number,
                               po_vStatusComment   out varchar2,
                               rs                  out RetRefCursor) 
  is
  
    strSQL       varchar2(4000);
    
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    strSQL := 'select ';
    
    --patient id
    strSQL := strSQL || ' p.PATIENT_ID, ';
    
    --first name
    strSQL := strSQL || ' tbicds.fnc_utl_decstr(p.FIRST_NAME, 
              :pi_vKey, p.PATIENT_ID) as first_name, ';
    
    --mi          
    strSQL := strSQL || ' tbicds.fnc_utl_decstr(p.MI, 
              :pi_vKey, p.PATIENT_ID) as mi, ';
    
    --last name
    strSQL := strSQL || ' tbicds.fnc_utl_decstr(p.LAST_NAME, 
              :pi_vKey, p.PATIENT_ID) as last_name, ';
              
    --full_name
    strSQL := strSQL || '( tbicds.fnc_utl_decstr(p.FIRST_NAME, 
                        :pi_vKey, p.PATIENT_ID) || '' '' || ' 
                        || ' tbicds.fnc_utl_decstr(p.MI, 
                        :pi_vKey, p.PATIENT_ID) || '' '' || ' 
                        || ' tbicds.fnc_utl_decstr(p.LAST_NAME,
                        :pi_vKey, p.PATIENT_ID)) as full_name, ';
    
    --gender          
    strSQL := strSQL || ' tbicds.fnc_utl_decstr(p.GENDER, 
              :pi_vKey, p.PATIENT_ID) as gender, ';
    
    --dob          
    strSQL := strSQL || ' to_date(tbicds.fnc_utl_decstr(p.dob, 
              :pi_vKey, p.PATIENT_ID), ''MM/DD/YYYY'') as dob, ';
    
    --home phone  
    strSQL := strSQL || ' p.HOMEPHONE, ';
    
    --cell phone
    strSQL := strSQL || ' p.CELLPHONE, ';
    
    --work phone
    strSQL := strSQL || ' p.WORKPHONE, ';
    
    --email
    strSQL := strSQL || ' tbicds.fnc_utl_decstr(p.EMAIL, 
           :pi_vKey, p.PATIENT_ID) as email, ';
    
    --patient age
    strSQL := strSQL || ' trunc(months_between(SYSDATE, 
           to_date(tbicds.fnc_utl_decstr(p.dob, 
           :pi_vKey, p.PATIENT_ID), ''MM/DD/YYYY'')) / 12) 
           as patient_age ';
        
    strSQL := strSQL || ' from tbicds.patient_demographics p ';

    strSQL := strSQL || ' where ';
 
    --add only patients with events   
    strSQL := strSQL || '((select count(*) from pat_pw_event ppe ';
    strSQL := strSQL || ' where ppe.patient_id = p.patient_id) > 0) and ';
    
    --only patients with sites = users site     
    strSQL := strSQL || ' p.site_id in (';
        
    strSQL := strSQL || 'select site_id ';
    strSQL := strSQL || '  from tbicds.fx_user s ';
    strSQL := strSQL || ' where s.fx_user_id = :pi_nUserID ) ';
    
    strSQL := strSQL || ' order by 
              (tbicds.fnc_utl_decstr(p.LAST_NAME, 
              :pi_vKey, p.PATIENT_ID)) asc ';
  
  
    open rs for strSQL 
    using pi_vKey,
          pi_vKey,
          pi_vKey,
          pi_vKey,
          pi_vKey,
          pi_vKey,
          pi_vKey,
          pi_vKey,
          pi_vKey,
          pi_vKey,
          pi_nUserID,
          pi_vKey;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'Error retrieving population';
  end;


end PCK_REPORTS_PAT;
/

